<?php

namespace WP_Defender\Model\Notification;

use WP_Defender\Model\Scan;

class Malware_Report extends \WP_Defender\Model\Notification {
	protected $table = 'wd_malware_scanning_report';

	public function before_load() {
		$default = array(
			'slug'                 => 'malware-report',
			'title'                => __( 'Malware Scanning - Reporting', 'wpdef' ),
			'status'               => self::STATUS_DISABLED,
			'description'          => __( 'Automatically run regular scans of your website and email you reports.', 'wpdef' ),
			'in_house_recipients'  => array(
				$this->get_default_user(),
			),
			'out_house_recipients' => array(),
			'type'                 => 'report',
			'frequency'            => 'weekly',
			'day'                  => 'sunday',
			'day_n'                => '1',
			'time'                 => '4:00',
			'dry_run'              => false,
			'configs'              => array(
				'always_send' => false,
				'error_send'  => false,
				'template'    => array(
					'found'     => array(
						'subject' => __( 'Scan of {SITE_URL} complete. {ISSUES_COUNT} issues found.', 'wpdef' ),
						'body'    => __(
							'Hi {USER_NAME},

WP Defender here, reporting back from the front.

I\'ve finished scanning {SITE_URL} for vulnerabilities and I found {ISSUES_COUNT} issues that you should take a closer look at!
{ISSUES_LIST}

Stay Safe,
WP Defender
WPMU DEV Superhero
',
							'wpdef'
						),
					),
					'not_found' => array(
						'subject' => __( 'Scan of {SITE_URL} complete. {ISSUES_COUNT} issues found.', 'wpdef' ),
						'body'    => __(
							'Hi {USER_NAME},

WP Defender here, reporting back from the front.

I\'ve finished scanning {SITE_URL} for vulnerabilities and I found nothing. Well done for running such a tight ship!

		Keep up the good work! With regular security scans and a well-hardened installation you\'ll be just fine.
                                                                                                           
Stay safe,
WP Defender
WPMU DEV Superhero
',
							'wpdef'
						),
					),
					'error'     => array(
						'subject' => __( 'Couldn’t scan {SITE_URL} for vulnerabilities. ', 'wpdef' ),
						'body'    => __(
							'Hi {USER_NAME},

WP Defender here, reporting back from the front.

I couldn’t scan {SITE_URL} for vulnerabilities. Please {follow this link} and check the logs to see what casued the failure.  

Stay Safe,
WP Defender
WPMU DEV Superhero
',
							'wpdef'
						),
					),
				),
			),
		);
		$this->import( $default );
	}

	/**
	 * @return bool
	 * @throws \Exception
	 */
	public function maybe_send() {
		if ( self::STATUS_ACTIVE !== $this->status ) {
			return false;
		}

		if (
			true === $this->dry_run
			&& ( empty( $this->last_sent ) || empty( $this->est_timestamp ) )
		) {
				$this->last_sent     = $this->est_timestamp;
				$this->est_timestamp = $this->get_next_run()->getTimestamp();
				$this->save();
		}
		$time = apply_filters( 'defender_current_time_for_report', new \DateTime( 'now', wp_timezone() ) );
		//Check by 'always_send' will be after after scanning is complete
		return $time->getTimestamp() >= $this->est_timestamp;
	}

	public function send() {
		$ret = Scan::create( true );
		if ( is_wp_error( $ret ) ) {
			//a scan already, do nothing
			return;
		}
		$this->last_sent     = $this->est_timestamp;
		$this->est_timestamp = $this->get_next_run()->getTimestamp();
		$this->save();
		wd_di()->get( \WP_Defender\Controller\Scan::class )->self_ping();
	}

	/**
	 * Define labels for settings key
	 *
	 * @param  string|null $key
	 *
	 * @return string|array|null
	 */
	public function labels( $key = null ) {
		$labels = array(
			'report'             => __( 'Malware Scanning - Reporting', 'wpdef' ),
			'always_send'        => __( 'Send notifications when no issues are detected', 'wpdef' ),
			'report_subscribers' => __( 'Recipients', 'wpdef' ),
			'day'                => __( 'Day of', 'wpdef' ),
			'day_n'              => __( 'Day of', 'wpdef' ),
			'time'               => __( 'Time of day', 'wpdef' ),
			'frequency'          => __( 'Frequency', 'wpdef' ),
			'dry_run'            => '',
		);

		if ( ! is_null( $key ) ) {
			return isset( $labels[ $key ] ) ? $labels[ $key ] : null;
		}

		return $labels;
	}

	/**
	 * @return string
	 */
	public function get_next_run_for_hub() {

		return self::STATUS_ACTIVE === $this->status
			? $this->persistent_hub_datetime_format( $this->est_timestamp )
			: __( 'Never', 'wpdef' );
	}
}
