<?php

namespace Drupal\rhythm_shortcodes\Controller;

use Drupal\Component\Utility\Html;
use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * Controller routines for page example routes.
 */
class RhythmShortcodesController extends ControllerBase {

  /**
   * @param \Symfony\Component\HttpFoundation\Request $request
   * @return \Symfony\Component\HttpFoundation\JsonResponse
   */
  public function ajax_social_icons_autocomplete(Request $request) {
    $matches = [];
    $string = $request->query->get('q');
    if ($string) {
      $icons = [
        'icon-twitter',
        'icon-dribbble',
        'icon-facebook',
        'icon-duckduckgo',
        'icon-aim',
        'icon-delicious',
        'icon-paypal',
        'icon-android',
        'icon-gplus',
        'icon-lanyrd',
        'icon-stumbleupon',
        'icon-fivehundredpx',
        'icon-pinterest',
        'icon-bitcoin',
        'icon-w3c',
        'icon-foursquare',
        'icon-html5',
        'icon-ie',
        'icon-grooveshark',
        'icon-ninetyninedesigns',
        'icon-forrst',
        'icon-spotify',
        'icon-reddit',
        'icon-gowalla',
        'icon-appstore',
        'icon-blogger',
        'icon-cc',
        'icon-evernote',
        'icon-flickr',
        'icon-google',
        'icon-viadeo',
        'icon-instapaper',
        'icon-klout',
        'icon-linkedin',
        'icon-meetup',
        'icon-vk',
        'icon-disqus',
        'icon-rss',
        'icon-skype',
        'icon-youtube',
        'icon-vimeo',
        'icon-windows',
        'icon-xing',
        'icon-yahoo',
        'icon-chrome',
        'icon-macstore',
        'icon-amazon',
        'icon-steam',
        'icon-dropbox',
        'icon-cloudapp',
        'icon-ebay',
        'icon-github',
        'icon-googleplay',
        'icon-itunes',
        'icon-plurk',
        'icon-songkick',
        'icon-lastfm',
        'icon-gmail',
        'icon-pinboard',
        'icon-openid',
        'icon-quora',
        'icon-soundcloud',
        'icon-tumblr',
        'icon-eventasaurus',
        'icon-wordpress',
        'icon-yelp',
        'icon-intensedebate',
        'icon-eventbrite',
        'icon-scribd',
        'icon-posterous',
        'icon-stripe',
        'icon-opentable',
        'icon-instagram',
        'icon-dwolla',
        'icon-appnet',
        'icon-statusnet',
        'icon-acrobat',
        'icon-drupal',
        'icon-pocket',
        'icon-bitbucket',
        'icon-flattr',
        'icon-eventful',
        'icon-smashmag',
        'icon-wordpress',
        'icon-calendar',
        'icon-call',
        'icon-guest',
        'icon-weibo',
        'icon-plancast',
        'icon-email',
        'icon-myspace',
        'icon-podcast',
        'icon-cart'
      ];

      $matches = [];
      foreach ($icons as $icon) {
        if (stripos($icon, $string) !== FALSE) {
          $matches[$icon] = $icon;
        }
      }
    }
    return new JsonResponse(array_values($matches));
  }

  /**
   * @param \Symfony\Component\HttpFoundation\Request $request
   * @return \Symfony\Component\HttpFoundation\JsonResponse
   */
  public function ajax_livicons_autocomplete(Request $request) {
    $matches = [];
    $string = $request->query->get('q');
    if ($string) {
      $icons = [
        'at',
        'balloons',
        'bank',
        'bomb',
        'calculator',
        'folders',
        'ice-cream',
        'medkit',
        'paper-plane',
        'wine',
        'address-book',
        'adjust',
        'alarm',
        'albums',
        'align-center',
        'align-justify',
        'align-left',
        'align-right',
        'anchor',
        'android',
        'angle-double-down',
        'angle-double-left',
        'angle-double-right',
        'angle-double-up',
        'angle-down',
        'angle-left',
        'angle-right',
        'angle-up',
        'angle-wide-down',
        'angle-wide-left',
        'angle-wide-right',
        'angle-wide-up',
        'apple',
        'apple-logo',
        'archive-add',
        'archive-extract',
        'arrow-circle-down',
        'arrow-circle-left',
        'arrow-circle-right',
        'arrow-circle-up',
        'arrow-down',
        'arrow-left',
        'arrow-right',
        'arrow-up',
        'asterisk',
        'balance',
        'ban',
        'barchart',
        'barcode',
        'battery',
        'beer',
        'bell',
        'bing',
        'biohazard',
        'bitbucket',
        'blogger',
        'bluetooth',
        'bold',
        'bolt',
        'bookmark',
        'bootstrap',
        'briefcase',
        'brightness-down',
        'brightness-up',
        'brush',
        'bug',
        'calendar',
        'camcoder',
        'camera',
        'camera-alt',
        'car',
        'caret-down',
        'caret-left',
        'caret-right',
        'caret-up',
        'cellphone',
        'certificate',
        'check',
        'check-circle',
        'check-circle-alt',
        'checked-off',
        'checked-on',
        'chevron-down',
        'chevron-left',
        'chevron-right',
        'chevron-up',
        'chrome',
        'circle',
        'circle-alt',
        'clapboard',
        'clip',
        'clock',
        'cloud',
        'cloud-bolts',
        'cloud-down',
        'cloud-rain',
        'cloud-snow',
        'cloud-sun',
        'cloud-up',
        'code',
        'collapse-down',
        'collapse-up',
        'columns',
        'comment',
        'comments',
        'compass',
        'concrete5',
        'connect',
        'credit-card',
        'crop',
        'css3',
        'dashboard',
        'desktop',
        'deviantart',
        'disconnect',
        'doc-landscape',
        'doc-portrait',
        'download',
        'download-alt',
        'dribbble',
        'drop',
        'dropbox',
        'edit',
        'exchange',
        'expand-left',
        'expand-right',
        'external-link',
        'eye-close',
        'eye-open',
        'eyedropper',
        'facebook',
        'facebook-alt',
        'file-export',
        'file-import',
        'film',
        'filter',
        'fire',
        'firefox',
        'flag',
        'flickr',
        'flickr-alt',
        'folder-add',
        'folder-flag',
        'folder-lock',
        'folder-new',
        'folder-open',
        'folder-remove',
        'font',
        'gear',
        'gears',
        'ghost',
        'gift',
        'github',
        'github-alt',
        'glass',
        'globe',
        'google-plus',
        'google-plus-alt',
        'hammer',
        'hand-down',
        'hand-left',
        'hand-right',
        'hand-up',
        'heart',
        'heart-alt',
        'help',
        'home',
        'html5',
        'ie',
        'image',
        'inbox',
        'inbox-empty',
        'inbox-in',
        'inbox-out',
        'indent-left',
        'indent-right',
        'info',
        'instagram',
        'ios',
        'italic',
        'jquery',
        'key',
        'lab',
        'laptop',
        'leaf',
        'legal',
        'linechart',
        'link',
        'linkedin',
        'linkedin-alt',
        'list',
        'list-ol',
        'list-ul',
        'livicon',
        'location',
        'lock',
        'magic',
        'magic-alt',
        'magnet',
        'mail',
        'mail-alt',
        'map',
        'medal',
        'message-add',
        'message-flag',
        'message-in',
        'message-lock',
        'message-new',
        'message-out',
        'message-remove',
        'microphone',
        'minus',
        'minus-alt',
        'money',
        'moon',
        'more',
        'morph-c-o',
        'morph-c-s',
        'morph-c-t-down',
        'morph-c-t-left',
        'morph-c-t-right',
        'morph-c-t-up',
        'morph-o-c',
        'morph-o-s',
        'morph-o-t-down',
        'morph-o-t-left',
        'morph-o-t-right',
        'morph-o-t-up',
        'morph-s-c',
        'morph-s-o',
        'morph-s-t-down',
        'morph-s-t-left',
        'morph-s-t-right',
        'morph-s-t-up',
        'morph-t-down-c',
        'morph-t-down-o',
        'morph-t-down-s',
        'morph-t-left-c',
        'morph-t-left-o',
        'morph-t-left-s',
        'morph-t-right-c',
        'morph-t-right-o',
        'morph-t-right-s',
        'morph-t-up-c',
        'morph-t-up-o',
        'morph-t-up-s',
        'move',
        'music',
        'myspace',
        'new-window',
        'notebook',
        'opera',
        'pacman',
        'paypal',
        'pen',
        'pencil',
        'phone',
        'piechart',
        'piggybank',
        'pin-off',
        'pin-on',
        'pinterest',
        'pinterest-alt',
        'plane-down',
        'plane-up',
        'playlist',
        'plus',
        'plus-alt',
        'presentation',
        'printer',
        'qrcode',
        'question',
        'quote-left',
        'quote-right',
        'raphael',
        'recycled',
        'reddit',
        'redo',
        'refresh',
        'remove',
        'remove-alt',
        'remove-circle',
        'resize-big',
        'resize-big-alt',
        'resize-horizontal',
        'resize-horizontal-alt',
        'resize-small',
        'resize-small-alt',
        'resize-vertical',
        'resize-vertical-alt',
        'responsive',
        'responsive-menu',
        'retweet',
        'rocket',
        'rotate-left',
        'rotate-right',
        'rss',
        'safari',
        'sandglass',
        'save',
        'scissors',
        'screen-full',
        'screen-full-alt',
        'screen-small',
        'screen-small-alt',
        'screenshot',
        'search',
        'servers',
        'settings',
        'share',
        'shield',
        'shopping-cart',
        'shopping-cart-in',
        'shopping-cart-out',
        'shuffle',
        'sign-in',
        'sign-out',
        'signal',
        'sitemap',
        'sky-dish',
        'skype',
        'sort',
        'sort-down',
        'sort-up',
        'soundcloud',
        'speaker',
        'spinner-five',
        'spinner-four',
        'spinner-one',
        'spinner-seven',
        'spinner-six',
        'spinner-three',
        'spinner-two',
        'star-empty',
        'star-full',
        'star-half',
        'stopwatch',
        'striked',
        'stumbleupon',
        'stumbleupon-alt',
        'sun',
        'table',
        'tablet',
        'tag',
        'tags',
        'tasks',
        'text-decrease',
        'text-height',
        'text-increase',
        'text-size',
        'text-width',
        'thermo-down',
        'thermo-up',
        'thumbnails-big',
        'thumbnails-small',
        'thumbs-down',
        'thumbs-up',
        'timer',
        'trash',
        'tree',
        'trophy',
        'truck',
        'tumblr',
        'twitter',
        'twitter-alt',
        'umbrella',
        'underline',
        'undo',
        'unlink',
        'unlock',
        'upload',
        'upload-alt',
        'user',
        'user-add',
        'user-ban',
        'user-flag',
        'user-remove',
        'users',
        'users-add',
        'users-ban',
        'users-remove',
        'vector-circle',
        'vector-curve',
        'vector-line',
        'vector-polygon',
        'vector-square',
        'video-backward',
        'video-eject',
        'video-fast-backward',
        'video-fast-forward',
        'video-forward',
        'video-pause',
        'video-play',
        'video-play-alt',
        'video-step-backward',
        'video-step-forward',
        'video-stop',
        'vimeo',
        'vk',
        'warning',
        'warning-alt',
        'webcam',
        'wifi',
        'wifi-alt',
        'windows',
        'windows8',
        'wordpress',
        'wordpress-alt',
        'wrench',
        'xing',
        'yahoo',
        'youtube',
        'zoom-in',
        'zoom-out'
      ];

      $matches = [];
      foreach ($icons as $icon) {
        if (stripos($icon, $string) !== FALSE) {
          $matches[$icon] = $icon;
        }
      }
    }
    return new JsonResponse(array_values($matches));
  }

  /**
   * @param \Symfony\Component\HttpFoundation\Request $request
   * @return \Symfony\Component\HttpFoundation\JsonResponse
   */
  public function ajax_fontawesome_icons_autocomplete(Request $request) {
    $matches = [];
    $string = $request->query->get('q');
    if ($string) {
      $icons = [
        'fa fa-glass',
        'fa fa-music',
        'fa fa-search',
        'fa fa-envelope-o',
        'fa fa-heart',
        'fa fa-star',
        'fa fa-star-o',
        'fa fa-user',
        'fa fa-film',
        'fa fa-th-large',
        'fa fa-th',
        'fa fa-th-list',
        'fa fa-check',
        'fa fa-remove',
        'fa fa-search-plus',
        'fa fa-search-minus',
        'fa fa-power-off',
        'fa fa-signal',
        'fa fa-gear',
        'fa fa-trash-o',
        'fa fa-home',
        'fa fa-file-o',
        'fa fa-clock-o',
        'fa fa-road',
        'fa fa-download',
        'fa fa-arrow-circle-o-down',
        'fa fa-arrow-circle-o-up',
        'fa fa-inbox',
        'fa fa-play-circle-o',
        'fa fa-rotate-right',
        'fa fa-refresh',
        'fa fa-list-alt',
        'fa fa-lock',
        'fa fa-flag',
        'fa fa-headphones',
        'fa fa-volume-off',
        'fa fa-volume-down',
        'fa fa-volume-up',
        'fa fa-qrcode',
        'fa fa-barcode',
        'fa fa-tag',
        'fa fa-tags',
        'fa fa-book',
        'fa fa-bookmark',
        'fa fa-print',
        'fa fa-camera',
        'fa fa-font',
        'fa fa-bold',
        'fa fa-italic',
        'fa fa-text-height',
        'fa fa-text-width',
        'fa fa-align-left',
        'fa fa-align-center',
        'fa fa-align-right',
        'fa fa-align-justify',
        'fa fa-list',
        'fa fa-dedent',
        'fa fa-indent',
        'fa fa-video-camera',
        'fa fa-photo',
        'fa fa-pencil',
        'fa fa-map-marker',
        'fa fa-adjust',
        'fa fa-tint',
        'fa fa-edit',
        'fa fa-share-square-o',
        'fa fa-check-square-o',
        'fa fa-arrows',
        'fa fa-step-backward',
        'fa fa-fast-backward',
        'fa fa-backward',
        'fa fa-play',
        'fa fa-pause',
        'fa fa-stop',
        'fa fa-forward',
        'fa fa-fast-forward',
        'fa fa-step-forward',
        'fa fa-eject',
        'fa fa-chevron-left',
        'fa fa-chevron-right',
        'fa fa-plus-circle',
        'fa fa-minus-circle',
        'fa fa-times-circle',
        'fa fa-check-circle',
        'fa fa-question-circle',
        'fa fa-info-circle',
        'fa fa-crosshairs',
        'fa fa-times-circle-o',
        'fa fa-check-circle-o',
        'fa fa-ban',
        'fa fa-arrow-left',
        'fa fa-arrow-right',
        'fa fa-arrow-up',
        'fa fa-arrow-down',
        'fa fa-mail-forward',
        'fa fa-expand',
        'fa fa-compress',
        'fa fa-plus',
        'fa fa-minus',
        'fa fa-asterisk',
        'fa fa-exclamation-circle',
        'fa fa-gift',
        'fa fa-leaf',
        'fa fa-fire',
        'fa fa-eye',
        'fa fa-eye-slash',
        'fa fa-warning',
        'fa fa-plane',
        'fa fa-calendar',
        'fa fa-random',
        'fa fa-comment',
        'fa fa-magnet',
        'fa fa-chevron-up',
        'fa fa-chevron-down',
        'fa fa-retweet',
        'fa fa-shopping-cart',
        'fa fa-folder',
        'fa fa-folder-open',
        'fa fa-arrows-v',
        'fa fa-arrows-h',
        'fa fa-bar-chart-o',
        'fa fa-twitter-square',
        'fa fa-facebook-square',
        'fa fa-camera-retro',
        'fa fa-key',
        'fa fa-gears',
        'fa fa-comments',
        'fa fa-thumbs-o-up',
        'fa fa-thumbs-o-down',
        'fa fa-star-half',
        'fa fa-heart-o',
        'fa fa-sign-out',
        'fa fa-linkedin-square',
        'fa fa-thumb-tack',
        'fa fa-external-link',
        'fa fa-sign-in',
        'fa fa-trophy',
        'fa fa-github-square',
        'fa fa-upload',
        'fa fa-lemon-o',
        'fa fa-phone',
        'fa fa-square-o',
        'fa fa-bookmark-o',
        'fa fa-phone-square',
        'fa fa-twitter',
        'fa fa-facebook-f',
        'fa fa-github',
        'fa fa-unlock',
        'fa fa-credit-card',
        'fa fa-feed',
        'fa fa-hdd-o',
        'fa fa-bullhorn',
        'fa fa-bell',
        'fa fa-certificate',
        'fa fa-hand-o-right',
        'fa fa-hand-o-left',
        'fa fa-hand-o-up',
        'fa fa-hand-o-down',
        'fa fa-arrow-circle-left',
        'fa fa-arrow-circle-right',
        'fa fa-arrow-circle-up',
        'fa fa-arrow-circle-down',
        'fa fa-globe',
        'fa fa-wrench',
        'fa fa-tasks',
        'fa fa-filter',
        'fa fa-briefcase',
        'fa fa-arrows-alt',
        'fa fa-group',
        'fa fa-chain',
        'fa fa-cloud',
        'fa fa-flask',
        'fa fa-cut',
        'fa fa-copy',
        'fa fa-paperclip',
        'fa fa-save',
        'fa fa-square',
        'fa fa-navicon',
        'fa fa-list-ul',
        'fa fa-list-ol',
        'fa fa-strikethrough',
        'fa fa-underline',
        'fa fa-table',
        'fa fa-magic',
        'fa fa-truck',
        'fa fa-pinterest',
        'fa fa-pinterest-square',
        'fa fa-google-plus-square',
        'fa fa-google-plus',
        'fa fa-money',
        'fa fa-caret-down',
        'fa fa-caret-up',
        'fa fa-caret-left',
        'fa fa-caret-right',
        'fa fa-columns',
        'fa fa-unsorted',
        'fa fa-sort-down',
        'fa fa-sort-up',
        'fa fa-envelope',
        'fa fa-linkedin',
        'fa fa-rotate-left',
        'fa fa-legal',
        'fa fa-dashboard',
        'fa fa-comment-o',
        'fa fa-comments-o',
        'fa fa-flash',
        'fa fa-sitemap',
        'fa fa-umbrella',
        'fa fa-paste',
        'fa fa-lightbulb-o',
        'fa fa-exchange',
        'fa fa-cloud-download',
        'fa fa-cloud-upload',
        'fa fa-user-md',
        'fa fa-stethoscope',
        'fa fa-suitcase',
        'fa fa-bell-o',
        'fa fa-coffee',
        'fa fa-cutlery',
        'fa fa-file-text-o',
        'fa fa-building-o',
        'fa fa-hospital-o',
        'fa fa-ambulance',
        'fa fa-medkit',
        'fa fa-fighter-jet',
        'fa fa-beer',
        'fa fa-h-square',
        'fa fa-plus-square',
        'fa fa-angle-double-left',
        'fa fa-angle-double-right',
        'fa fa-angle-double-up',
        'fa fa-angle-double-down',
        'fa fa-angle-left',
        'fa fa-angle-right',
        'fa fa-angle-up',
        'fa fa-angle-down',
        'fa fa-desktop',
        'fa fa-laptop',
        'fa fa-tablet',
        'fa fa-mobile-phone',
        'fa fa-circle-o',
        'fa fa-quote-left',
        'fa fa-quote-right',
        'fa fa-spinner',
        'fa fa-circle',
        'fa fa-mail-reply',
        'fa fa-github-alt',
        'fa fa-folder-o',
        'fa fa-folder-open-o',
        'fa fa-smile-o',
        'fa fa-frown-o',
        'fa fa-meh-o',
        'fa fa-gamepad',
        'fa fa-keyboard-o',
        'fa fa-flag-o',
        'fa fa-flag-checkered',
        'fa fa-terminal',
        'fa fa-code',
        'fa fa-mail-reply-all',
        'fa fa-star-half-empty',
        'fa fa-location-arrow',
        'fa fa-crop',
        'fa fa-code-fork',
        'fa fa-unlink',
        'fa fa-question',
        'fa fa-info',
        'fa fa-exclamation',
        'fa fa-superscript',
        'fa fa-subscript',
        'fa fa-eraser',
        'fa fa-puzzle-piece',
        'fa fa-microphone',
        'fa fa-microphone-slash',
        'fa fa-shield',
        'fa fa-calendar-o',
        'fa fa-fire-extinguisher',
        'fa fa-rocket',
        'fa fa-maxcdn',
        'fa fa-chevron-circle-left',
        'fa fa-chevron-circle-right',
        'fa fa-chevron-circle-up',
        'fa fa-chevron-circle-down',
        'fa fa-html5',
        'fa fa-css3',
        'fa fa-anchor',
        'fa fa-unlock-alt',
        'fa fa-bullseye',
        'fa fa-ellipsis-h',
        'fa fa-ellipsis-v',
        'fa fa-rss-square',
        'fa fa-play-circle',
        'fa fa-ticket',
        'fa fa-minus-square',
        'fa fa-minus-square-o',
        'fa fa-level-up',
        'fa fa-level-down',
        'fa fa-check-square',
        'fa fa-pencil-square',
        'fa fa-external-link-square',
        'fa fa-share-square',
        'fa fa-compass',
        'fa fa-toggle-down',
        'fa fa-toggle-up',
        'fa fa-toggle-right',
        'fa fa-euro',
        'fa fa-gbp',
        'fa fa-dollar',
        'fa fa-rupee',
        'fa fa-cny',
        'fa fa-ruble',
        'fa fa-won',
        'fa fa-bitcoin',
        'fa fa-file',
        'fa fa-file-text',
        'fa fa-sort-alpha-asc',
        'fa fa-sort-alpha-desc',
        'fa fa-sort-amount-asc',
        'fa fa-sort-amount-desc',
        'fa fa-sort-numeric-asc',
        'fa fa-sort-numeric-desc',
        'fa fa-thumbs-up',
        'fa fa-thumbs-down',
        'fa fa-youtube-square',
        'fa fa-youtube',
        'fa fa-xing',
        'fa fa-xing-square',
        'fa fa-youtube-play',
        'fa fa-dropbox',
        'fa fa-stack-overflow',
        'fa fa-instagram',
        'fa fa-flickr',
        'fa fa-adn',
        'fa fa-bitbucket',
        'fa fa-bitbucket-square',
        'fa fa-tumblr',
        'fa fa-tumblr-square',
        'fa fa-long-arrow-down',
        'fa fa-long-arrow-up',
        'fa fa-long-arrow-left',
        'fa fa-long-arrow-right',
        'fa fa-apple',
        'fa fa-windows',
        'fa fa-android',
        'fa fa-linux',
        'fa fa-dribbble',
        'fa fa-skype',
        'fa fa-foursquare',
        'fa fa-trello',
        'fa fa-female',
        'fa fa-male',
        'fa fa-gittip',
        'fa fa-sun-o',
        'fa fa-moon-o',
        'fa fa-archive',
        'fa fa-bug',
        'fa fa-vk',
        'fa fa-weibo',
        'fa fa-renren',
        'fa fa-pagelines',
        'fa fa-stack-exchange',
        'fa fa-arrow-circle-o-right',
        'fa fa-arrow-circle-o-left',
        'fa fa-toggle-left',
        'fa fa-dot-circle-o',
        'fa fa-wheelchair',
        'fa fa-vimeo-square',
        'fa fa-turkish-lira',
        'fa fa-plus-square-o',
        'fa fa-space-shuttle',
        'fa fa-slack',
        'fa fa-envelope-square',
        'fa fa-wordpress',
        'fa fa-openid',
        'fa fa-institution',
        'fa fa-mortar-board',
        'fa fa-yahoo',
        'fa fa-google',
        'fa fa-reddit',
        'fa fa-reddit-square',
        'fa fa-stumbleupon-circle',
        'fa fa-stumbleupon',
        'fa fa-delicious',
        'fa fa-digg',
        'fa fa-pied-piper',
        'fa fa-pied-piper-alt',
        'fa fa-drupal',
        'fa fa-joomla',
        'fa fa-language',
        'fa fa-fax',
        'fa fa-building',
        'fa fa-child',
        'fa fa-paw',
        'fa fa-spoon',
        'fa fa-cube',
        'fa fa-cubes',
        'fa fa-behance',
        'fa fa-behance-square',
        'fa fa-steam',
        'fa fa-steam-square',
        'fa fa-recycle',
        'fa fa-automobile',
        'fa fa-cab',
        'fa fa-tree',
        'fa fa-spotify',
        'fa fa-deviantart',
        'fa fa-soundcloud',
        'fa fa-database',
        'fa fa-file-pdf-o',
        'fa fa-file-word-o',
        'fa fa-file-excel-o',
        'fa fa-file-powerpoint-o',
        'fa fa-file-photo-o',
        'fa fa-file-zip-o',
        'fa fa-file-sound-o',
        'fa fa-file-movie-o',
        'fa fa-file-code-o',
        'fa fa-vine',
        'fa fa-codepen',
        'fa fa-jsfiddle',
        'fa fa-life-bouy',
        'fa fa-circle-o-notch',
        'fa fa-ra',
        'fa fa-ge',
        'fa fa-git-square',
        'fa fa-git',
        'fa fa-y-combinator-square',
        'fa fa-tencent-weibo',
        'fa fa-qq',
        'fa fa-wechat',
        'fa fa-send',
        'fa fa-send-o',
        'fa fa-history',
        'fa fa-circle-thin',
        'fa fa-header',
        'fa fa-paragraph',
        'fa fa-sliders',
        'fa fa-share-alt',
        'fa fa-share-alt-square',
        'fa fa-bomb',
        'fa fa-soccer-ball-o',
        'fa fa-tty',
        'fa fa-binoculars',
        'fa fa-plug',
        'fa fa-slideshare',
        'fa fa-twitch',
        'fa fa-yelp',
        'fa fa-newspaper-o',
        'fa fa-wifi',
        'fa fa-calculator',
        'fa fa-paypal',
        'fa fa-google-wallet',
        'fa fa-cc-visa',
        'fa fa-cc-mastercard',
        'fa fa-cc-discover',
        'fa fa-cc-amex',
        'fa fa-cc-paypal',
        'fa fa-cc-stripe',
        'fa fa-bell-slash',
        'fa fa-bell-slash-o',
        'fa fa-trash',
        'fa fa-copyright',
        'fa fa-at',
        'fa fa-eyedropper',
        'fa fa-paint-brush',
        'fa fa-birthday-cake',
        'fa fa-area-chart',
        'fa fa-pie-chart',
        'fa fa-line-chart',
        'fa fa-lastfm',
        'fa fa-lastfm-square',
        'fa fa-toggle-off',
        'fa fa-toggle-on',
        'fa fa-bicycle',
        'fa fa-bus',
        'fa fa-ioxhost',
        'fa fa-angellist',
        'fa fa-cc',
        'fa fa-shekel',
        'fa fa-meanpath',
        'fa fa-buysellads',
        'fa fa-connectdevelop',
        'fa fa-dashcube',
        'fa fa-forumbee',
        'fa fa-leanpub',
        'fa fa-sellsy',
        'fa fa-shirtsinbulk',
        'fa fa-simplybuilt',
        'fa fa-skyatlas',
        'fa fa-cart-plus',
        'fa fa-cart-arrow-down',
        'fa fa-diamond',
        'fa fa-ship',
        'fa fa-user-secret',
        'fa fa-motorcycle',
        'fa fa-street-view',
        'fa fa-heartbeat',
        'fa fa-venus',
        'fa fa-mars',
        'fa fa-mercury',
        'fa fa-intersex',
        'fa fa-transgender-alt',
        'fa fa-venus-double',
        'fa fa-mars-double',
        'fa fa-venus-mars',
        'fa fa-mars-stroke',
        'fa fa-mars-stroke-v',
        'fa fa-mars-stroke-h',
        'fa fa-neuter',
        'fa fa-genderless',
        'fa fa-facebook-official',
        'fa fa-pinterest-p',
        'fa fa-whatsapp',
        'fa fa-server',
        'fa fa-user-plus',
        'fa fa-user-times',
        'fa fa-hotel',
        'fa fa-viacoin',
        'fa fa-train',
        'fa fa-subway',
        'fa fa-medium',
        'fa fa-yc',
        'fa fa-optin-monster',
        'fa fa-opencart',
        'fa fa-expeditedssl',
        'fa fa-battery-4',
        'fa fa-battery-3',
        'fa fa-battery-2',
        'fa fa-battery-1',
        'fa fa-battery-0',
        'fa fa-mouse-pointer',
        'fa fa-i-cursor',
        'fa fa-object-group',
        'fa fa-object-ungroup',
        'fa fa-sticky-note',
        'fa fa-sticky-note-o',
        'fa fa-cc-jcb',
        'fa fa-cc-diners-club',
        'fa fa-clone',
        'fa fa-balance-scale',
        'fa fa-hourglass-o',
        'fa fa-hourglass-1',
        'fa fa-hourglass-2',
        'fa fa-hourglass-3',
        'fa fa-hourglass',
        'fa fa-hand-grab-o',
        'fa fa-hand-stop-o',
        'fa fa-hand-scissors-o',
        'fa fa-hand-lizard-o',
        'fa fa-hand-spock-o',
        'fa fa-hand-pointer-o',
        'fa fa-hand-peace-o',
        'fa fa-trademark',
        'fa fa-registered',
        'fa fa-creative-commons',
        'fa fa-gg',
        'fa fa-gg-circle',
        'fa fa-tripadvisor',
        'fa fa-odnoklassniki',
        'fa fa-odnoklassniki-square',
        'fa fa-get-pocket',
        'fa fa-wikipedia-w',
        'fa fa-safari',
        'fa fa-chrome',
        'fa fa-firefox',
        'fa fa-opera',
        'fa fa-internet-explorer',
        'fa fa-tv',
        'fa fa-contao',
        'fa fa-500px',
        'fa fa-amazon',
        'fa fa-calendar-plus-o',
        'fa fa-calendar-minus-o',
        'fa fa-calendar-times-o',
        'fa fa-calendar-check-o',
        'fa fa-industry',
        'fa fa-map-pin',
        'fa fa-map-signs',
        'fa fa-map-o',
        'fa fa-map',
        'fa fa-commenting',
        'fa fa-commenting-o',
        'fa fa-houzz',
        'fa fa-vimeo',
        'fa fa-black-tie',
        'fa fa-fonticons'
      ];

      $matches = [];
      foreach ($icons as $icon) {
        if (stripos($icon, $string) !== FALSE) {
          $matches[$icon] = $icon;
        }
      }
    }
    return new JsonResponse(array_values($matches));
  }

  /**
   * @param \Symfony\Component\HttpFoundation\Request $request
   * @return \Symfony\Component\HttpFoundation\JsonResponse
   */
  public function ajax_node_autocomplete(Request $request) {
    $matches = [];
    $string = $request->query->get('q');
    if ($string) {
      $query = \Drupal::database()->select('node_field_data', 'nfd');
      $return = $query
        ->fields('nfd', ['nid', 'title'])
        ->condition('nfd.title', '%' . $query->escapeLike($string) . '%', 'LIKE')
        ->range(0, 15)
        ->execute();

      foreach ($return as $row) {
        $matches['node/' . $row->nid . '/edit'] = Html::escape($row->title);
      }
    }

    return new JsonResponse(array_values($matches));
  }

}
